#ifndef __INIT__H__
#define __INIT__H__


/*
   *  Object %name    : SEPDriver.h
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:39:24 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief  Key Management h file (API and structures )
   *
   *  \version 
   *  \author yevgenys
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/*------------------------------
    DEFINES
--------------------------------*/

#define HW_CC_SRAM_BASE_ADDRESS             0x0FC8
#define HW_CC_SRAM_LCS_ADDRESS              0x0F40

typedef enum
{
  DX_CC_START_IllaglResult_t,
  DX_CC_START_fatalError_t,
  DX_CC_START_ColdBootFirstPhaseComplete_t,
  DX_CC_START_ColdBootFirstPhaseCompleteWithWarning_t,
  DX_CC_START_ColdBootComplete_t,
  DX_CC_START_ColdBootCompleteWithWarning_t,
  DX_CC_START_WarmBootComplete_t,
  DX_CC_START_WarmBootCompleteWithWarning_t,
  DX_CC_START_ColdWarmBootComplete_t,
  DX_CC_START_ColdWarmBootCompleteWithWarning_t,
  DX_CC_START_ICacheFailure_t,
  DX_CC_START_BootLast       = 0x7FFFFFFF,
}DX_CC_START_CCResult_t;

 
typedef enum
{
	DX_CC_INIT_OEM_KEY_TYPE = 1,
	DX_CC_INIT_EXT1_TYPE,
	DX_CC_INIT_EXT2_TYPE,
	DX_CC_INIT_EXT3_TYPE,
	DX_CC_INIT_EXT4_TYPE,
	DX_CC_INIT_LastKey       = 0x7FFFFFFF,	
}DX_CC_INIT_KEY_TYPES;


/*-------------------------------
  STRUCTURES
---------------------------------*/



/*----------------------------------------------
    FUNCTIONS
--------------------------------------------------*/


/**
 * @brief      This function checks that the SEP stage initialization completion succuesfully 
 *             The function checks the SEP error, in case it is OK it returns its state
 *             else it returns the error.
 *             In case of fatal error it returns the casue of the error.
 *             In case of BM error it retuns BM_Error
 *                        
 * @param[OUT] CCResult_ptr - Ste state of the SEP incase it is not in an error.
 *                            In case of NULL pointer not status is return.
 * @return     DxError:  
 *                        
 */
DxError_t DX_CC_StartExt(DX_CC_START_CCResult_t *CCResult_ptr, DxUint32_t * warningVal_ptr );


/* Simple call without the result */
#define DX_CC_Start()		DX_CC_StartExt(DX_NULL,DX_NULL)

/**
 * @brief      This function finilizes the ROM BOOT process - should be called last. It sends to SEP
 *             the data that is needed for the successfull completion of the SEP setup
 * 
 * @param[in] HostMemoryBaseAddr - the start address of the host code
 * @param[in] HostSharedAreaAddress - the start address of the shared aread between Host and SEP (data area that can be directly accessed by SEP
 * @param[in] HostSharedAreaSize - the size of the shared area
 * @param[in] HostResidentBaseAddress - the start address of the resident code of SEP
 * @param[in] HostCacheBaseAddress - the start address of the cache
 *
 * @return     DxError:  
 *                        
 */
DxError_t DX_CC_Init(DxUint32_t    HostMemoryBaseAddr,
                     DxUint32_t    HostSharedAreaAddress,
                     DxUint32_t    HostSharedAreaSize,
                     DxUint32_t    HostResidentBaseAddress,
                     DxUint32_t    HostCacheBaseAddress,
                     DxUint32_t    HostExtCacheBaseAddress,
                     DxUint32_t    HostDCacheBaseAddress,
                     DxUint32_t    HostDCacheAreaSize,
                     DxUint32_t    HostDCacheHeapSize,
                     DxUint32_t    HostDCacheStackSize,
                     DxUint32_t    HostDCacheGlbBaseAddress);




/**
 * @brief      This function initiate and load the external cache image. 
 * 
 * @param[in] HostExtCacheBaseAddress - the start address of the cache
 * @param[in] keyType - the index of the Hashed RSA public key
 *
 * @return     DxError:  
 *                        
 */
DxError_t DX_CC_InitExt(DxUint32_t HostExtCacheBaseAddress, DX_CC_INIT_KEY_TYPES keyType);

#endif
